<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

$conn = mysqli_connect("localhost", "root", "", "db_tugasakhir");
if (!$conn) {
    die("Koneksi gagal: " . mysqli_connect_error());
}


if (isset($_GET['hapus']) && $_SESSION['role'] === 'admin') {
    $id = (int) $_GET['hapus'];
    mysqli_query($conn, "DELETE FROM produk WHERE id_produk = $id");
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}


if (isset($_POST['proses']) && $_SESSION['role'] === 'admin') {
    $nama_produk = $_POST['nama_produk'];
    $kategori    = $_POST['kategori'];
    $harga       = (int) $_POST['harga'];
    $deskripsi   = $_POST['deskripsi'];
    $stok        = (int) $_POST['stok'];
    $total_harga = $harga * $stok;

    $query = "INSERT INTO produk
              (nama_produk, kategori, harga, deskripsi, stok, total_harga)
              VALUES
              ('$nama_produk','$kategori','$harga','$deskripsi','$stok','$total_harga')";
    mysqli_query($conn, $query);

    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}



$kataKunci = isset($_GET['kataKunci']) ? $_GET['kataKunci'] : "";
$sql = ($kataKunci != "")
    ? "SELECT * FROM produk WHERE nama_produk LIKE '%$kataKunci%' OR kategori LIKE '%$kataKunci%'"
    : "SELECT * FROM produk";

$dataProduk = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Aplikasi Gudang Frozen Food</title>
    <style>
        .search-box {
            margin-bottom: 20px;
        }

        .search-box form {
            display: flex;
            gap: 8px;
            width: 320px;
        }

        .search-box input {
           flex: 1;
           padding: 8px;
        }

        .search-box button {
           padding: 8px 14px;
           background: #3498db;
           border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }

        body {
            font-family: Arial, sans-serif;
            background:#f5f6fa;
            margin:30px;
        }
        h1 {
            text-align:center;
            color:red;
            margin-bottom:30px;
        }
        h2 {
            background:#3498db;
            color:white;
            padding:10px;
            border-radius:5px;
            width:max-content;
        }
        .card {
            background:white;
            padding:20px;
            width:340px;
            border-radius:8px;
            box-shadow:0 4px 10px rgba(0,0,0,.1);
            margin-bottom:30px;
        }

        
        input, textarea {
            width:95%;
            padding:10px;
            margin-top:5px;
        }
        input[type=submit] {
            background:#2ecc71;
            color:white;
            border:none;
            cursor:pointer;
            font-weight:bold;
        }
        table {
            width:100%;
            background:white;
            border-collapse:collapse;
        }
        th {
            background:#3498db;
            color:white;
            padding:10px;
        }
        td {
            padding:8px;
            border-bottom:1px solid #eee;
        }
        a.hapus-btn {
            background:#e74c3c;
            color:white;
            padding:5px 10px;
            text-decoration:none;
            border-radius:4px;
        }

        .kategori-group {
            margin: 10px 0 15px;
        }

        .kategori-group label {
            display: inline-flex;
            align-items: center;
            margin-right: 15px;
            cursor: pointer;
            font-weight: normal;
        }

        .kategori-group input[type="radio"] {
            margin-right: 6px;
        }

    </style>
</head>

<body>

<?php include 'header.php'; ?>

<h1>SALMAN FROZEN FOOD SUPLIER</h1>

<div class="search-box">
    <form method="get">
        <input type="text" name="kataKunci" placeholder="Cari produk..."
               value="<?= htmlspecialchars($kataKunci) ?>">
        <button type="submit">Cari</button>
    </form>
</div>


<?php if ($_SESSION['role'] === 'admin') { ?>
<div class="card">
    <h2>Tambah Produk</h2>
    <form method="post">
        Nama Produk:
        <input type="text" name="nama_produk" required>

        Kategori:
<div class="kategori-group">
    <label>
        <input type="radio" name="kategori" value="Makanan" required>
        Makanan
    </label>
    <label>
        <input type="radio" name="kategori" value="Minuman">
        Minuman
    </label>
    <label>
        <input type="radio" name="kategori" value="Lainnya">
        Lainnya
    </label>
</div>


        Harga:
        <input type="number" name="harga" required>

        Deskripsi:
        <textarea name="deskripsi"></textarea>

        Stok:
        <input type="number" name="stok" required>

        <input type="submit" name="proses" value="SIMPAN">
    </form>
</div>
<?php } ?>

<h2>Data Pesanan</h2>

<table>
<tr>
    <th>Nama</th>
    <th>Kategori</th>
    <th>Harga</th>
    <th>Deskripsi</th>
    <th>Tanggal</th>
    <th>Stok</th>
    <th>Total</th>
    <th>Aksi</th>
</tr>

<?php while ($row = mysqli_fetch_assoc($dataProduk)) { ?>
<tr>
    <td><?= htmlspecialchars($row['nama_produk']) ?></td>
    <td><?= $row['kategori'] ?></td>
    <td><?= number_format($row['harga']) ?></td>
    <td><?= htmlspecialchars($row['deskripsi']) ?></td>
    <td><?= $row['tanggal_input'] ?></td>
    <td><?= $row['stok'] ?></td>
    <td><?= number_format($row['total_harga']) ?></td>
    <td>
        <?php if ($_SESSION['role'] === 'admin') { ?>
            <a class="hapus-btn"
               href="?hapus=<?= $row['id_produk'] ?>"
               onclick="return confirm('Yakin hapus?')">Hapus</a>
        <?php } else { ?>
            -
        <?php } ?>
    </td>
</tr>
<?php } ?>
</table>

</body>
</html>
